/***************************************************************************
 *   Copyright (C) 2009 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DLG_MOTORMIXER_H
#define DLG_MOTORMIXER_H

#include <QObject>
#include <QFileDialog>
#include <QSettings>

#include "ui_dlg_MotorMixer.h"
#include "../Classes/cSettings.h"
#include "../Classes/cConnection.h"
#include "../typedefs.h"
#include "../Classes/ToolBox.h"
#include "../global.h"

class dlg_MotorMixer : public QDialog, public Ui::dlg_MotorMixer_UI
{
     Q_OBJECT

public:
    dlg_MotorMixer(QWidget *parent = 0);
    void set_Objects(cConnection *t_Connection, cSettings *t_Settings);
    void set_MotorConfig(sRxData RX);
    void read_Mixer();

private:
    // Object für Kopter-Verbindung
    cConnection *o_Connection;

    cSettings *o_Settings;

    char TX_Data[150];

    int Motor[16][4];
    QString MixerName;
    int MixerVersion;

    void set_MotorData();
    void get_MotorData();
    int get_MotorConfig();

private slots:
    void slot_pb_READ();
    void slot_pb_WRITE();
    void slot_pb_LOAD();
    void slot_pb_SAVE();
    void slot_CheckValue(int Wert);
};

#endif // DLG_MOTORMIXER_H
